// Programme (V.5.2) à téléverser dans la CARD1 = AVR (Mega, Nano... ou autre) 
// Si IDE Arduino, choisir carte : 
// si carte Nano          =>    Arduino Nano
// si carte Mega          =>    Arduino Mega or Meag 2560



#include <Arduino_JSON.h>

//========== REGLAGES
  uint32_t timerDelay     = 1000;       // Fréquence d'envoi vers l'ESP8266 (Node, D1...)
  uint32_t speedSerial    = 115200;     // Vitesse moniteur série
  uint32_t speedSerial1   = 115200;     // Vitesse envoi des données vers le NODE

  #ifndef Serial1                       // Si c'est une Uno | Nano..., donc sans Serial1, on utilise SoftwareSerail
  #include <SoftwareSerial.h>
  #define RX_PIN 10                     // Broche choisie
  #define TX_PIN 11                     // Broche choisie
  SoftwareSerial Serial1(RX_PIN, TX_PIN);
  #endif 
 

//========== OBJETS ET VARABLES GLOBAUX
  JSONVar readings;

//========== BUFFER et autres
  //----- Variables devant contenir les valeurs de capteurs (variables à mettre à jour dans le programme)
  String   data_card1_1;           // Exemple
  int      data_card1_2;           // Exemple : Entier 16bits
  float    data_card1_3;           // Exemple : Nbr à virgule
  int32_t  data_card1_4;           // Exemple : Entier 32bits
  uint32_t data_card1_5;           // Exemple : Entier 32bits non signé
  String   data_card1_6;           // Exemple 


//======== FACILITATEURS
  // MACRO : Limiteur de fréquence
    #define LIMIT_FREQ_BEGIN(varName, duration) static uint32_t varName = 0; if(millis()>varName+duration){
    #define LIMIT_FREQ_END(varName) varName = millis();}

  // MACRO : Limiteur de répétition
    #define LIMIT_REP_BEGIN(varName, nbrOfRep) static uint8_t varName = 0; if(varName<nbrOfRep){
    #define LIMIT_REP_END(varName) varName++;}

  // MACRO : Setup virtuel
    #define SETUP_VIR_BEGIN(varName) static uint8_t varName = 0; if(varName<1){
    #define SETUP_VIR_END(varName) varName++;}


//========== PROTOTYPES DE FONCTIONS
String getSensorReadings();


void setup(){
  Serial.begin(speedSerial);  while(!Serial);
  Serial1.begin(speedSerial1);while(!Serial1);  
  Serial.println("Serials:ok");
}

void loop(){
  
  //----- Récupération des données des capteurs la MEGA (capteurs locaux)      
      data_card1_1  = "Hello MEGA!";                         // Exemple chaîne simple
      data_card1_2  = 4321;                                  // Exemple nbr 2 octets
      data_card1_3  = 2.10;                                  // Exemple nbr float
      data_card1_4  = 987654321;                             // Exemple nbr 4 octets 
      data_card1_5  = random(0,10000);                       // Exemple nbr 4 octets non signés (au hasard)
      data_card1_6  = "<span style='color:green;'>GREEN<span>";  // Exemple String avec injection html

  //----- Envoie les données complètes à la CARD2
    LIMIT_FREQ_BEGIN(sendingNodeData, timerDelay)
      Serial.println(getSensorReadings());
      Serial1.println(getSensorReadings());
    LIMIT_FREQ_END(sendingNodeData)
}



////////////////////////////////////////////////////////////////////////////////
//                            IMPLEMENTATIONS DE FONCTIONS                    //
////////////////////////////////////////////////////////////////////////////////

String getSensorReadings() {
  //Exemple JSON {"DATA1":"1234","DATA2":"3.14","DATA3":"Hello world","DATA4":"-12345678","DATA5":"123456789","DATA6":"a"}
  // Les noms des étiquettes DATAx doivent être les mêmes que dans l'id html ! (exemple avec DATAx)
  readings["DATA-CARD1-1"]    = String( data_card1_1 );
  readings["DATA-CARD1-2"]    = String( data_card1_2 );
  readings["DATA-CARD1-3"]    = String( data_card1_3 );
  readings["DATA-CARD1-4"]    = String( data_card1_4 );
  readings["DATA-CARD1-5"]    = String( data_card1_5 );
  readings["DATA-CARD1-6"]    = String( data_card1_6 );

  String jsonString = JSON.stringify(readings);
  return jsonString;
}
