// Programme (V.5.2) à téléverser dans la CARD2 = ESP8266 (Node, D1 mini ou autre...) 
// Si IDE Arduino, choisir carte : 
// si carte D1 mini       =>    LOLIN(WEMOS) D1 mini lite
// si carte Node MCU      =>    NodeMCU 1.0


#include <Arduino.h>
#include <ESP8266WiFi.h>
#include <ESP8266WiFiMulti.h>
#include <ESPAsyncTCP.h>
#include <ESPAsyncWebServer.h>
#include "LittleFS.h"
#include <Arduino_JSON.h>

//========== TODO PROF
//OpenData
//QR-code

//========== QUOI RÉGLER ? 
//0-Veillez à avoir un point d'accès avec la bande de fréquences 2.4Ghz active (l'encryption PSK n'est pas compatible)
//1-Dans REGLAGE_01 : Remplacez les SSID et PASS par ceux disponibles (vous pouvez laisser des lignes vides) 
//2-Dans REGLAGE_02 : Ouvrez le moniteur série et ajustez la vitesse à la valeur indiquée (115200 bauds ici)
//3-Dans REGLAGE_03 : Décommenter la ligne si vous souhaitez héberger les pages dans le Node
//4-Dans REGLAGE_04 : Décommenter la ligne et donnez un nom à votre Node si vous pouvez utiliser mDns


//========== REGLAGES_00
//===== REGLAGES_00 : Point d'accès
// Il doit avoir la bande de fréquence 2,4Ghz active
// Il ne doit pas utiliser le PSK !



//===== REGLAGES_01 : Modifiez les SSID et PASS ci-dessous en fonction des points d'accès disponibles 
  //---- Si vous n'avez qu'un point d'accès, mettre 3 fois le même SVP

  //---- Point d'accès disponible 1 
  #define AP1_SSID "AZERTY42"
  #define AP1_PASS "AZERTY42"
  
  //---- Point d'accès disponible 2
  #define AP2_SSID "AZERTY42"
  #define AP2_PASS "AZERTY42"

  //---- Point d'accès disponible 3
  #define AP3_SSID "AZERTY42"
  #define AP3_PASS "AZERTY42"



//===== REGLAGES_02 : Vitesse moniteur série
uint32_t speedSerial    = 115200;



//===== REGLAGES_03 : littleFs (permet d'héberger les fichiers)
#define ENABLE_LITTLE_FS


//===== REGLAGES_04 : mDNS (permet de pouvoir charger la page par http://nom.local) - Pas compatible avec tout !
//#define ENABLE_MDNS
//#define NAME_MDNS "esp" // Le nom auquel doit répondre le CARD2 (ici, c'est http://esp.local)


//===== Réglage de la fréquence de rafraîchissement (pas trop vite SVP)
unsigned long timerDelay = 2000; // Fréquence de rafraîchissement imposée par le Node



//========== OBJETS ET VARIABLES
//----- Création d'un objet server sur le port 80 pour répondre à la requête http://192.168.x.x
AsyncWebServer server(80);

//----- Création d'un objet Websocket
AsyncWebSocket ws("/ws");

//----- Création d'un objet WifiMulti pour gérer plusieurs point d'accès
ESP8266WiFiMulti wifiMulti;


//========== BUFFER et autres
//----- Chaînes JSON
String jsonStringCard1    = "";  // Contiendra la chaîne JSON reçue de la CARD1
String jsonStringAll      = "";  // Contiendra la chaîne JSON complète envoyée à la page web

//----- Variables devant contenir les valeurs de capteurs (variables à mettre à jour dans le programme)
  /*
  String   data_card2_1;           // Exemple
  int      data_card2_2;           // Exemple : Entier 16bits
  float    data_card2_3;           // Exemple : Nbr à virgule
  int32_t  data_card2_4;           // Exemple : Entier 32bits
  uint32_t data_card2_5;           // Exemple : Entier 32bits non signé
  String   data_card2_6;           // Exemple
  */

uint32_t data_card2_1 = 0;                                        // Exemple
uint32_t data_card2_2 = 0;                                        // Exemple
uint32_t data_card2_3 = 0;                                        // Exemple
uint32_t data_card2_4 = 0;                                        // Exemple
uint32_t data_card2_5 = 0;                                        // Exemple
uint32_t data_card2_6 = 0;                                        // Exemple


//======== FACILITATEURS (ne pas changer SVP)
// MACRO : Limiteur de fréquence
#define LIMIT_FREQ_BEGIN(varName, duration) static uint32_t varName = 0; if(millis()>varName+duration)
#define LIMIT_FREQ_END(varName) varName = millis()

// MACRO : Limiteur de répétition
#define LIMIT_REP_BEGIN(varName, nbrOfRep) static uint8_t varName = 0; if(varName<nbrOfRep)
#define LIMIT_REP_END(varName) varName++

// MACRO : Setup virtuel
#define SETUP_VIR_BEGIN(varName) static uint8_t varName = 0; if(varName<1)
#define SETUP_VIR_END(varName) varName++


//========== PROTOTYPES DE FONCTIONS (pour que VSCode soit contant)
String  getSensorReadings();
String  getSensorReadingsCard1();
void    initWifiMulti();
void    notifyClients(String sensorReadings);
void    handleWebSocketMessage(void *arg, uint8_t *data, size_t len);
void    onEvent(AsyncWebSocket *server, AsyncWebSocketClient *client, AwsEventType type, void *arg, uint8_t *data, size_t len);
void    initWebSocket();
void    initFS();
void    manageMdns();
String  checkAndReadsCard1Data();


//======================================== SETUP() =======================================
void setup() {
  //---------- Initialisation des liaisons séries
  Serial.begin(speedSerial); while (!Serial); // Utiliser pour débogage & réception données de la CARD1
  Serial.println(); Serial.println("Serial:ok");

  //---------- Initialisation du Wifi (ancienne méthode)
  //initWiFi();

  //---------- Initialisation du wifi-multi (nouvelle méthode)
  wifiMulti.addAP(AP1_SSID, AP1_PASS);
  wifiMulti.addAP(AP2_SSID, AP2_PASS);
  wifiMulti.addAP(AP3_SSID, AP3_PASS);
  initWifiMulti();

  //---------- Initialisation du websocket
  initWebSocket();

  //---------- Initialisation du SPIFF (appelé maintenant Little FS sur les ESP8266)
  #if defined ENABLE_LITTLE_FS
  initFS();
  
  //---- Initialisation du serveur
  server.on("/", HTTP_GET, [](AsyncWebServerRequest * request) {
    request->send(LittleFS, "/index.html", "text/html");
  });
  server.serveStatic("/", LittleFS, "/");
  server.begin();
  #endif
}



//======================================== LOOP() ========================================
void loop() {

  //========== OPTION : MDNS : ne fonctionne pas toujours - (il faut un navigateur compatible hélas)
  #if defined ENABLE_MDNS
    manageMdns();
  #endif

  //========== Récupération des données de la CARD1 (capteurs distants)
  jsonStringCard1 = checkAndReadsCard1Data();

  //========== Récupération des données des capteurs de l'ESP8266 (mise à jour des valeurs de capteurs locaux)
  /* Exemple
    data_card2_1  = "Hello CARD2!";                        // Exemple chaîne simple
    data_card2_2  = random(0,1000);                        // Exemple nbr 2 octets
    data_card2_3  = 0.12;                                  // Exemple nbr float
    data_card2_4  = 123456789;                             // Exemple nbr 4 octets
    data_card2_5  = random(0,10000);                       // Exemple nbr 4 octets non signés (au hasard)
    data_card2_6  = "<span style='color:red;'>RED<span>";  // Exemple String avec injection html
    //*/
  ///*
  data_card2_1 = random(0, 1000);                          // Exemple avec des données aléatoires
  data_card2_2 = random(0, 1000);                          // Exemple avec des données aléatoires
  data_card2_3 = random(0, 1000);                          // Exemple avec des données aléatoires
  data_card2_4 = random(0, 1000);                          // Exemple avec des données aléatoires
  data_card2_5 = random(0, 1000);                          // Exemple avec des données aléatoires
  data_card2_6 = random(0, 1000);                          // Exemple avec des données aléatoires
  //*/


  //========== Envoie les données complètes à la page web
  LIMIT_FREQ_BEGIN(sendingWebData, timerDelay) {
    String sensorReadings = getSensorReadings();
    Serial.print("CARD2>");
    Serial.println(sensorReadings);
    notifyClients(sensorReadings);
    LIMIT_FREQ_END(sendingWebData);
  }

  //========== Gestion des clients
  ws.cleanupClients();

}



/////////////////////////////////////////////////////////////////////////////////////////
//                                IMPLÉMENTATIONS DE FONCTIONS                         //
/////////////////////////////////////////////////////////////////////////////////////////

String getSensorReadings() {
  // Utilité : récupère les données de la carte2 et de la carte1 et retourne une chaîne JSON

  //========== Récupération des données locales à la carte 2
  // Les noms des étiquettes DATA-X-X doivent être les mêmes que dans le code html !
  // On peut injecter de l'html de manière dynamique ici(à utiliser avec parcimoni car envoyé régulièrement !)
  JSONVar jsonObjectAll;
  jsonObjectAll["DATA-CARD2-1"]    = String( data_card2_1 );
  jsonObjectAll["DATA-CARD2-2"]    = String( data_card2_2 );
  jsonObjectAll["DATA-CARD2-3"]    = String( data_card2_3 );
  jsonObjectAll["DATA-CARD2-4"]    = String( data_card2_4 );
  jsonObjectAll["DATA-CARD2-5"]    = String( data_card2_5 );
  jsonObjectAll["DATA-CARD2-6"]    = String( data_card2_6 );

  //========== Ajout des données de la CARD1
  // Les données sont dans jsonStringCARD1 qui est une chaîne au format JSON
  JSONVar jsonObjectCard1 = JSON.parse(jsonStringCard1);
  jsonObjectAll["DATA-CARD1-DISTANT-1"]   =   String(jsonObjectCard1["DATA-CARD1-1"]);
  jsonObjectAll["DATA-CARD1-DISTANT-2"]   =   String(jsonObjectCard1["DATA-CARD1-2"]);
  jsonObjectAll["DATA-CARD1-DISTANT-3"]   =   String(jsonObjectCard1["DATA-CARD1-3"]);
  jsonObjectAll["DATA-CARD1-DISTANT-4"]   =   String(jsonObjectCard1["DATA-CARD1-4"]);
  jsonObjectAll["DATA-CARD1-DISTANT-5"]   =   String(jsonObjectCard1["DATA-CARD1-5"]);
  jsonObjectAll["DATA-CARD1-DISTANT-6"]   =   String(jsonObjectCard1["DATA-CARD1-6"]);

  jsonStringAll = JSON.stringify(jsonObjectAll);
  return jsonStringAll;
}

void initWifiMulti() {
  Serial.println("Tentative de connexion à un point d'accès disponible... ");
  //while (wifiMulti.run() != WL_CONNECTED) {
  //}

  tryWifi:
  if (wifiMulti.run() != WL_CONNECTED) {
    delay(500);
    Serial.print('.');
    goto tryWifi;
  }
  Serial.println('\n');
  Serial.print("Connecté à:\t\t\t");
  Serial.println(WiFi.SSID());
  Serial.print("Adresse IP:\t\t\t");
  Serial.println(WiFi.localIP());
  Serial.print("Force du signal(dBm):\t");
  Serial.println(WiFi.RSSI());
  Serial.print("Adresse MAC du Node:\t");
  Serial.println(WiFi.macAddress());  
}

void notifyClients(String sensorReadings) {
  ws.textAll(sensorReadings);
}

void handleWebSocketMessage(void *arg, uint8_t *data, size_t len) {
  AwsFrameInfo *info = (AwsFrameInfo*)arg;
  if (info->final && info->index == 0 && info->len == len && info->opcode == WS_TEXT) {
    //data[len] = 0;
    //String message = (char*)data;
    // Check if the message is "getReadings"
    //if (strcmp((char*)data, "getReadings") == 0) {
    //if it is, send current sensor readings
    String sensorReadings = getSensorReadings();
    //Serial.print(sensorReadings);
    notifyClients(sensorReadings);
    //}
  }
}

void onEvent(AsyncWebSocket *server, AsyncWebSocketClient *client, AwsEventType type, void *arg, uint8_t *data, size_t len) {
  switch (type) {
    case WS_EVT_CONNECT:
      Serial.printf("WebSocket client #%u connected from %s\n", client->id(), client->remoteIP().toString().c_str());
      break;
    case WS_EVT_DISCONNECT:
      Serial.printf("WebSocket client #%u disconnected\n", client->id());
      break;
    case WS_EVT_DATA:
      handleWebSocketMessage(arg, data, len);
      break;
    case WS_EVT_PONG:
    case WS_EVT_ERROR:
      break;
  }
}

void initWebSocket() {
  ws.onEvent(onEvent);
  server.addHandler(&ws);
}

String checkAndReadsCard1Data() {
  static String result = ""; // Evite de créer une variable globale en dehors de cette fonction
  if (Serial.available()) {
    result = Serial.readStringUntil('\n'); // Lecture d'une chaîne JSON complète
    Serial.print("CARD1>");
    Serial.println(result);
    Serial.flush();
    // A ce stade, la chaîne JSON envoyée par la CARD1 est dans result
  }
  return result;
}

//============================== OPION : LITTLE-FS (gestion des fichiers web)
#if defined ENABLE_LITTLE_FS
void initFS() {
  if (!LittleFS.begin()) {
    Serial.println("LittleFS a rencontré un problème");
  }
  else {
    Serial.println("LittleFS est fonctionnel");
  }
}
#endif

//============================== OPTION : MDNS (uniquement utile si vous voulez accéder à la page par http://nomMdns.local)
#if defined ENABLE_MDNS
#include <ESP8266mDNS.h>
void manageMdns() {
  const char* hostName  = NAME_MDNS;
  SETUP_VIR_BEGIN(mDns) {
    if (MDNS.begin(hostName)) {
      Serial.print("mDNS est actif. ");
      Serial.print("Votre CARD2 répondra à http://");
      Serial.print(hostName);
      Serial.println(".local (si navigateur compatible)");
      //MDNS.addService("http", "tcp", mdnsPort);
    } else {
      Serial.println("Erreur lors de l'activation de mDNS.");
    }
    SETUP_VIR_END(mDns);
  }
  MDNS.update();
}
#endif
