


// Programme à téléverser dans le NODE (V.5.1)
// Si Arduino, choisir carte : NodeMCU 1.0

#include <Arduino.h>
#include <ESP8266WiFi.h>
#include <ESP8266WiFiMulti.h>
#include <ESPAsyncTCP.h>
#include <ESPAsyncWebServer.h>
#include "LittleFS.h"
#include <Arduino_JSON.h>

//========== TODO PROF
//OpenData
//QR-code

//========== QUOI RÉGLER ? 
//0-Veillez à avoir un point d'accès avec la bande de fréquences 2.4Ghz active (l'encryption PSK n'est pas compatible)
//1-Dans REGLAGE_01 : Remplacez les SSID et PASS par ceux disponibles (vous pouvez laisser des lignes vides) 
//2-Dans REGLAGE_02 : Ouvrez le moniteur série et ajustez la vitesse à la valeur indiquée (115200 bauds ici)
//3-Dans REGLAGE_03 : Décommenter la ligne si vous souhaitez héberger les pages dans le Node
//4-Dans REGLAGE_04 : Décommenter la ligne et donnez un nom à votre Node si vous pouvez utiliser mDns


//========== REGLAGES_00
//===== REGLAGES_00 : Point d'accès
// Il doit avoir la bande de fréquence 2,4Ghz active
// Il ne doit pas utiliser le PSK !



//===== REGLAGES_01 : Modifiez les SSID et PASS ci-dessous en fonction des points d'accès disponibles 

  //---- Point d'accès disponible 1 
  #define AP1_SSID "AZERTY00"
  #define AP1_PASS "AZERTY00"
  
  //---- Point d'accès disponible 2
  #define AP2_SSID "AZERTY41_OPEN"
  #define AP2_PASS ""

  //---- Point d'accès disponible 3
  #define AP3_SSID ""
  #define AP3_PASS ""



//===== REGLAGES_02 : Vitesse moniteur série
uint32_t speedSerial    = 115200;



//===== REGLAGES_03 : littleFs (permet d'héberger les fichiers)
#define ENABLE_LITTLE_FS


//===== REGLAGES_04 : mDNS (permet de pouvoir charger la page par http://nom.local) - Pas compatible avec tout !
//#define ENABLE_MDNS
//#define NAME_MDNS "node" // Le nom auquel doit répondre le NODE (ici, c'est http://node.local)


//===== Réglage de la fréquence de rafraîchissement (pas trop vite SVP)
unsigned long timerDelay = 2000; // Fréquence de rafraîchissement imposée par le Node



//========== OBJETS ET VARIABLES
//----- Création d'un objet server sur le port 80 pour répondre à la requête http://192.168.x.x
AsyncWebServer server(80);

//----- Création d'un objet Websocket
AsyncWebSocket ws("/ws");

//----- Création d'un objet WifiMulti pour gérer plusieurs point d'accès
ESP8266WiFiMulti wifiMulti;


//========== BUFFER et autres
//----- Chaînes JSON
String jsonStringMega    = "";  // Contiendra la chaîne JSON reçue de la MEGA
String jsonStringAll     = "";  // Contiendra la chaîne JSON complète envoyée à la page web

//----- Variables devant contenir les valeurs de capteurs (variables à mettre à jour dans le programme)
  /*
  String   data_node_1;           // Exemple
  int      data_node_2;           // Exemple : Entier 16bits
  float    data_node_3;           // Exemple : Nbr à virgule
  int32_t  data_node_4;           // Exemple : Entier 32bits
  uint32_t data_node_5;           // Exemple : Entier 32bits non signé
  String   data_node_6;           // Exemple
  */

uint32_t data_node_1 = 0;                                        // Exemple
uint32_t data_node_2 = 0;                                        // Exemple
uint32_t data_node_3 = 0;                                        // Exemple
uint32_t data_node_4 = 0;                                        // Exemple
uint32_t data_node_5 = 0;                                        // Exemple
uint32_t data_node_6 = 0;                                        // Exemple


//======== FACILITATEURS (ne pas changer SVP)
// MACRO : Limiteur de fréquence
#define LIMIT_FREQ_BEGIN(varName, duration) static uint32_t varName = 0; if(millis()>varName+duration)
#define LIMIT_FREQ_END(varName) varName = millis()

// MACRO : Limiteur de répétition
#define LIMIT_REP_BEGIN(varName, nbrOfRep) static uint8_t varName = 0; if(varName<nbrOfRep)
#define LIMIT_REP_END(varName) varName++

// MACRO : Setup virtuel
#define SETUP_VIR_BEGIN(varName) static uint8_t varName = 0; if(varName<1)
#define SETUP_VIR_END(varName) varName++


//========== PROTOTYPES DE FONCTIONS (pour que VSCode soit contant)
String  getSensorReadings();
String  getSensorReadingsMega();
void    initWifiMulti();
void    notifyClients(String sensorReadings);
void    handleWebSocketMessage(void *arg, uint8_t *data, size_t len);
void    onEvent(AsyncWebSocket *server, AsyncWebSocketClient *client, AwsEventType type, void *arg, uint8_t *data, size_t len);
void    initWebSocket();
void    initFS();
void    manageMdns();


//======================================== SETUP() =======================================
void setup() {
  //---------- Initialisation des liaisons séries
  Serial.begin(speedSerial); while (!Serial); // Utiliser pour débogage & réception données de la MEGA
  Serial.println(); Serial.println("Serial:ok");

  //---------- Initialisation du Wifi (ancienne méthode)
  //initWiFi();

  //---------- Initialisation du wifi-multi (nouvelle méthode)
  wifiMulti.addAP(AP1_SSID, AP1_PASS);
  wifiMulti.addAP(AP2_SSID, AP2_PASS);
  wifiMulti.addAP(AP3_SSID, AP3_PASS);
  initWifiMulti();

  //---------- Initialisation du websocket
  initWebSocket();

  //---------- Initialisation du SPIFF (appelé maintenant Little FS sur les ESP8266)
  #if defined ENABLE_LITTLE_FS
  initFS();
  
  //---- Initialisation du serveur
  server.on("/", HTTP_GET, [](AsyncWebServerRequest * request) {
    request->send(LittleFS, "/index.html", "text/html");
  });
  server.serveStatic("/", LittleFS, "/");
  server.begin();
  #endif
}



//======================================== LOOP() ========================================
void loop() {

  //========== OPTION : MDNS : ne fonctionne pas toujours - (il faut un navigateur compatible hélas)
  #if defined ENABLE_MDNS
    manageMdns();
  #endif

  //========== Récupération des données de la MEGA (capteurs distants)
  jsonStringMega = checkAndReadsMegaData();

  //========== Récupération des données des capteurs la NODE (mise à jour des valeurs de capteurs locaux)
  /* Exemple
    data_node_1  = "Hello NODE!";                         // Exemple chaîne simple
    data_node_2  = random(0,1000);                        // Exemple nbr 2 octets
    data_node_3  = 0.12;                                  // Exemple nbr float
    data_node_4  = 123456789;                             // Exemple nbr 4 octets
    data_node_5  = random(0,10000);                       // Exemple nbr 4 octets non signés (au hasard)
    data_node_6  = "<span style='color:red;'>RED<span>";  // Exemple String avec injection html
    //*/
  ///*
  data_node_1 = random(0, 1000);                          // Exemple avec des données aléatoires
  data_node_2 = random(0, 1000);                          // Exemple avec des données aléatoires
  data_node_3 = random(0, 1000);                          // Exemple avec des données aléatoires
  data_node_4 = random(0, 1000);                          // Exemple avec des données aléatoires
  data_node_5 = random(0, 1000);                          // Exemple avec des données aléatoires
  data_node_6 = random(0, 1000);                          // Exemple avec des données aléatoires
  //*/


  //========== Envoie les données complètes à la page web
  LIMIT_FREQ_BEGIN(sendingWebData, timerDelay) {
    String sensorReadings = getSensorReadings();
    Serial.print("NODE>");
    Serial.println(sensorReadings);
    notifyClients(sensorReadings);
    LIMIT_FREQ_END(sendingWebData);
  }

  //========== Gestion des clients
  ws.cleanupClients();

}



/////////////////////////////////////////////////////////////////////////////////////////
//                                IMPLÉMENTATIONS DE FONCTIONS                         //
/////////////////////////////////////////////////////////////////////////////////////////

String getSensorReadings() {
  // Utilité : récupère les données du Node et de la MEGA et retourne une chaîne JSON

  //========== Récupération des données locales au NODE
  // Les noms des étiquettes DATA-X-X doivent être les mêmes que dans le code html !
  // On peut injecter de l'html de manière dynamique ici(à utiliser avec parcimoni car envoyé régulièrement !)
  JSONVar jsonObjectAll;
  jsonObjectAll["DATA-NODE-1"]    = String( data_node_1 );
  jsonObjectAll["DATA-NODE-2"]    = String( data_node_2 );
  jsonObjectAll["DATA-NODE-3"]    = String( data_node_3 );
  jsonObjectAll["DATA-NODE-4"]    = String( data_node_4 );
  jsonObjectAll["DATA-NODE-5"]    = String( data_node_5 );
  jsonObjectAll["DATA-NODE-6"]    = String( data_node_6 );

  //========== Ajout des données de la MEGA
  // Les données sont dans jsonStringMega qui est une chaîne au format JSON
  JSONVar jsonObjectMega = JSON.parse(jsonStringMega);
  jsonObjectAll["DATA-MEGA-DISTANT-1"]   =   String(jsonObjectMega["DATA-MEGA-1"]);
  jsonObjectAll["DATA-MEGA-DISTANT-2"]   =   String(jsonObjectMega["DATA-MEGA-2"]);
  jsonObjectAll["DATA-MEGA-DISTANT-3"]   =   String(jsonObjectMega["DATA-MEGA-3"]);
  jsonObjectAll["DATA-MEGA-DISTANT-4"]   =   String(jsonObjectMega["DATA-MEGA-4"]);
  jsonObjectAll["DATA-MEGA-DISTANT-5"]   =   String(jsonObjectMega["DATA-MEGA-5"]);
  jsonObjectAll["DATA-MEGA-DISTANT-6"]   =   String(jsonObjectMega["DATA-MEGA-6"]);

  jsonStringAll = JSON.stringify(jsonObjectAll);
  return jsonStringAll;
}

void initWifiMulti() {
  Serial.println("Tentative de connexion à un point d'accès disponible... ");
  //while (wifiMulti.run() != WL_CONNECTED) {
  //}

  tryWifi:
  if (wifiMulti.run() != WL_CONNECTED) {
    delay(500);
    Serial.print('.');
    goto tryWifi;
  }
  Serial.println('\n');
  Serial.print("Connecté à:\t\t\t");
  Serial.println(WiFi.SSID());
  Serial.print("Adresse IP:\t\t\t");
  Serial.println(WiFi.localIP());
  Serial.print("Force du signal(dBm):\t");
  Serial.println(WiFi.RSSI());
  Serial.print("Adresse MAC du Node:\t");
  Serial.println(WiFi.macAddress());  
}

void notifyClients(String sensorReadings) {
  ws.textAll(sensorReadings);
}

void handleWebSocketMessage(void *arg, uint8_t *data, size_t len) {
  AwsFrameInfo *info = (AwsFrameInfo*)arg;
  if (info->final && info->index == 0 && info->len == len && info->opcode == WS_TEXT) {
    //data[len] = 0;
    //String message = (char*)data;
    // Check if the message is "getReadings"
    //if (strcmp((char*)data, "getReadings") == 0) {
    //if it is, send current sensor readings
    String sensorReadings = getSensorReadings();
    //Serial.print(sensorReadings);
    notifyClients(sensorReadings);
    //}
  }
}

void onEvent(AsyncWebSocket *server, AsyncWebSocketClient *client, AwsEventType type, void *arg, uint8_t *data, size_t len) {
  switch (type) {
    case WS_EVT_CONNECT:
      Serial.printf("WebSocket client #%u connected from %s\n", client->id(), client->remoteIP().toString().c_str());
      break;
    case WS_EVT_DISCONNECT:
      Serial.printf("WebSocket client #%u disconnected\n", client->id());
      break;
    case WS_EVT_DATA:
      handleWebSocketMessage(arg, data, len);
      break;
    case WS_EVT_PONG:
    case WS_EVT_ERROR:
      break;
  }
}

void initWebSocket() {
  ws.onEvent(onEvent);
  server.addHandler(&ws);
}

String checkAndReadsMegaData() {
  static String result = ""; // Evite de créer une variable globale en dehors de cette fonction
  if (Serial.available()) {
    result = Serial.readStringUntil('\n'); // Lecture d'une chaîne JSON complète
    Serial.print("MEGA>");
    Serial.println(result);
    Serial.flush();
    // A ce stade, la chaîne JSON envoyée par la MEGA est dans result
  }
  return result;
}

//============================== OPION : LITTLE-FS (gestion des fichiers web)
#if defined ENABLE_LITTLE_FS
void initFS() {
  if (!LittleFS.begin()) {
    Serial.println("LittleFS a rencontré un problème");
  }
  else {
    Serial.println("LittleFS est fonctionnel");
  }
}
#endif

//============================== OPTION : MDNS (uniquement utile si vous voulez accéder à la page par http://nomMdns.local)
#if defined ENABLE_MDNS
#include <ESP8266mDNS.h>
void manageMdns() {
  const char* hostName  = NAME_MDNS;
  SETUP_VIR_BEGIN(mDns) {
    if (MDNS.begin(hostName)) {
      Serial.print("mDNS est actif. ");
      Serial.print("Votre NODE répondra à http://");
      Serial.print(hostName);
      Serial.println(".local (si navigateur compatible)");
      //MDNS.addService("http", "tcp", mdnsPort);
    } else {
      Serial.println("Erreur lors de l'activation de mDNS.");
    }
    SETUP_VIR_END(mDns);
  }
  MDNS.update();
}
#endif


