#include <Arduino_JSON.h>

//========== REGLAGES
  uint32_t timerDelay     = 1000;       // Fréquence d'envoi vers le NODE
  uint32_t speedSerial    = 115200;     // Vitesse moniteur série
  uint32_t speedSerial1   = 115200;     // Vitesse envoi des données vers le NODE
  


//========== OBJETS ET VARABLES GLOBAUX
  JSONVar readings;

//========== BUFFER et autres
  //----- Variables devant contenir les valeurs de capteurs (variables à mettre à jour dans le programme)
  String   data_mega_1;           // Exemple
  int      data_mega_2;           // Exemple : Entier 16bits
  float    data_mega_3;           // Exemple : Nbr à virgule
  int32_t  data_mega_4;           // Exemple : Entier 32bits
  uint32_t data_mega_5;           // Exemple : Entier 32bits non signé
  String   data_mega_6;           // Exemple 


//======== FACILITATEURS
  // MACRO : Limiteur de fréquence
    #define LIMIT_FREQ_BEGIN(varName, duration) static uint32_t varName = 0; if(millis()>varName+duration){
    #define LIMIT_FREQ_END(varName) varName = millis();}

  // MACRO : Limiteur de répétition
    #define LIMIT_REP_BEGIN(varName, nbrOfRep) static uint8_t varName = 0; if(varName<nbrOfRep){
    #define LIMIT_REP_END(varName) varName++;}

  // MACRO : Setup virtuel
    #define SETUP_VIR_BEGIN(varName) static uint8_t varName = 0; if(varName<1){
    #define SETUP_VIR_END(varName) varName++;}


//========== PROTOTYPES DE FONCTIONS
String getSensorReadings();


void setup(){
  Serial.begin(speedSerial);  while(!Serial);
  Serial1.begin(speedSerial1);while(!Serial1);  
  Serial.println("Serials:ok");
}

void loop(){
  
  //----- Récupération des données des capteurs la MEGA (capteurs locaux)      
      data_mega_1  = "Hello MEGA!";                         // Exemple chaîne simple
      data_mega_2  = 4321;                                  // Exemple nbr 2 octets
      data_mega_3  = 2.10;                                  // Exemple nbr float
      data_mega_4  = 987654321;                             // Exemple nbr 4 octets 
      data_mega_5  = random(0,10000);                       // Exemple nbr 4 octets non signés (au hasard)
      data_mega_6  = "<span style='color:green;'>GREEN<span>";  // Exemple String avec injection html

  //----- Envoie les données complètes à la NODE
    LIMIT_FREQ_BEGIN(sendingNodeData, timerDelay)
      Serial.println(getSensorReadings());
      Serial1.println(getSensorReadings());
    LIMIT_FREQ_END(sendingNodeData)
}



////////////////////////////////////////////////////////////////////////////////
//                            IMPLEMENTATIONS DE FONCTIONS                    //
////////////////////////////////////////////////////////////////////////////////

String getSensorReadings() {
  //Exemple JSON {"DATA1":"1234","DATA2":"3.14","DATA3":"Hello world","DATA4":"-12345678","DATA5":"123456789","DATA6":"a"}
  // Les noms des étiquettes DATAx doivent être les mêmes que dans l'id html ! (exemple avec DATAx)
  readings["DATA-MEGA-1"]    = String( data_mega_1 );
  readings["DATA-MEGA-2"]    = String( data_mega_2 );
  readings["DATA-MEGA-3"]    = String( data_mega_3 );
  readings["DATA-MEGA-4"]    = String( data_mega_4 );
  readings["DATA-MEGA-5"]    = String( data_mega_5 );
  readings["DATA-MEGA-6"]    = String( data_mega_6 );

  String jsonString = JSON.stringify(readings);
  return jsonString;
}
