//========== Gestion de TeachableMachine
//Mettre ici l'url de votre modèle
const URL = "https://teachablemachine.withgoogle.com/models/h0pFkJRyV/";

let model, webcam, ctx, maxPredictions, recognizedMove, recognizedProba;

async function init() { //----[B1]:fonction lancée par l bouton
    
	console.log("On arrive dans init()");
	
	//---- Construction des URL du modèle
    const modelURL    = URL + "model.json";
    const metadataURL = URL + "metadata.json";
    
	//---- Chargement du modèle en ligne 
    model = await tmPose.load(modelURL, metadataURL);
    maxPredictions = model.getTotalClasses();
    
    //---- Gestion webcam et skeleton 	
    const size = 400;								// Taille de l'image webcam
    const flip = true; 								// Rotation horizontale de l'image
    webcam = new tmPose.Webcam(size, size, flip); 	
    await webcam.setup(); 							// Tentative d'initialisation webcam
    await webcam.play();
	window.requestAnimationFrame(loop);
	//----B2:Premier lancement du loop()
    const canvas = document.getElementById("div-cam");
    canvas.width = size; canvas.height = size;
    ctx = canvas.getContext("2d");
}

//----B3:le loop() se lance
async function loop(timestamp) {
    webcam.update(); 
	//----B4:la fonction predict() est appelée
    await predict();								// Appelle la fonction pour prédiction
    window.requestAnimationFrame(loop);				// La fonction loop s'appelle elle-même
}

//----B5:la fonction predict est appelée
async function predict() {
    
	//---- Données retournées par les modèle
    const { pose, posenetOutput } = await model.estimatePose(webcam.canvas);
    
	const prediction = await model.predict(posenetOutput);
		
    recognizedProba = prediction[0].probability.toFixed(2);  // Probabilité 
    recognizedMove  = prediction[0].className;               // Position reconnue

	for (let i = 1; i<maxPredictions; i++) {
		
		if(recognizedProba < prediction[i].probability.toFixed(2)){
            recognizedProba = prediction[i].probability.toFixed(2);
			recognizedMove  = prediction[i].className;
		}
    }
	//---- B6:On écrit le mouvement reconnu
	document.getElementById("mouv") .innerHTML = recognizedMove;
	//---- B7:On écrit la probabilité
	document.getElementById("proba").innerHTML = recognizedProba;
    //---- B8:On dessine le skeleton
    drawPose(pose);
}

function drawPose(pose) {
    if (webcam.canvas) {
		//---- B9:On dessine l'image de la webcam
        ctx.drawImage(webcam.canvas, 0, 0);
		//---- B10:On dessine le skeleton
        if (pose) {
            const minPartConfidence = 0.5;
            tmPose.drawKeypoints(pose.keypoints, minPartConfidence, ctx);
            tmPose.drawSkeleton (pose.keypoints, minPartConfidence, ctx);
        }
    }
}


function getRecognizedMove(){
    return recognizedMove;
}

function getRecognizedProba(){
    return recognizedProba;
}
