// Version V2.x

#include <Wire.h>
#include "Digital_Light_ISL29035.h"

void setup() {
  Wire.begin();
  Serial.begin(9600);

  if(ISL29035.init() < 0)
    Serial.println("ISL29035 init failed!");

  /**
   * Set the full scale range for lux measurement.
   * A lower range offers better resolution, it's suitable in a dim env,
   * while in light env, a higher range should be selected.
   * 0: 1000 lux, 1: 4000 lux, 2: 16000 lux, 3: 64000 lux
   * default index is 0.
   */
//  ISL29035.setFullScaleLuxRangeIndex(DEFAULT_LUX_RANGE_INDEX);
  /**
   * Set the integration time.
   * 0: 105ms, 1: 6.5ms, 2: 0.41ms, 3: 0.0256
   * default index is 0.
   */
//  ISL29035.setIntegrationTimeIndex(DEFAULT_INTEGRATION_TIME_INDEX);

  /**
   * The integration time is a trade-off between speed and accuracy.
   * Fast integration however gains lower resolution of ADC.
   */
}

void loop() {
  Serial.println("----");
  Serial.print("Ambient light intensity: ");
  Serial.println(ISL29035.readVisibleLux());

  Serial.print("IR intensity: ");
  Serial.println(ISL29035.readIRLux());

  Serial.print("Exposure value: ");
  Serial.println(ISL29035.readEV());

  delay(1000);
}



