/*
 
  Original Author: David Souder - souder.d@gmail.com
  Date de dernire modification : 27/05/2016
  
*/



	
#ifndef Duinoedu_Utility_H
	#define Duinoedu_Utility_H

	#if defined(ARDUINO) && ARDUINO >= 100
		#include "Arduino.h"
	#else
		#include <WProgram.h>
		#include "Wire.h"
	#endif


	#define JUMP "\r\n"
	#define _SEPARATOR    '='
	#define _END    '|'

class Duinoedu_Utility{

	public:
	Duinoedu_Utility();

};

//===== EMETEUR IR
	// IR : utiliser un metteur IR Grove pour une barrire
	void irGenerator(uint8_t _pin, uint8_t on, unsigned int frequency);
	
	// STRING : rcupration d'une valeur  partir d'une cl [EXEMPLE 01]
	String	findStringValue(String _bigString, String _key, char _separator, char _end=0);
	int findIntValue(String _bigString, String _key, char _separator, char _end=0);
	double findDoubleValue(String _bigString, String _key, char _separator, char _end=0);
	//Integer = findIntValue(String(Serial.read()), "key",'t','b') ;
	
	// Send : envoyer une valeur  partir d'une cl avec un sparateur et une fin
	String SendStringSerial(String _key, String _Value, char _separator='=', char _end=-1);




//===== CHRONOS
/*
class Chrono{
	public:
		Chrono();
		void 			start();
		uint32_t 		duration();
						uint32_t d;
						uint32_t timeLost;
						uint8_t  started;
		void 			reset();
};
*/

//===== ONLY EVERY ( utiliser 1 seule fois)
#define ONLY_EVERY(val) \
  static uint32_t lastTime = 0;\
  uint32_t thisTime = millis();\
  if( thisTime > (lastTime+val) ){\
  lastTime=thisTime;	
#define END_ONLY_EVERY }

//===== ONLY EVERY 

#define ONLY_EVERY(val, lastTimeVar) \
  static uint32_t lastTimeVar = 0;\
    if( millis()> (lastTimeVar+val) ){\
  lastTimeVar=millis();	

 #define END_ONLY_EVERY }
 



//===== ONLY EVERY
#define NOT_BEFORE(val) \
  if(millis()>val){
#define END_NOT_BEFORE }

//==== NOT MORE
#define NOT_MORE(nbr) \
	static uint32_t nbrOfTimes = 0;\
	if(nbrOfTimes <nbr+1){\
	nbrOfTimes++;
#define END_NOT_MORE }
	

//===== ANALOG READ WIDTH
#if defined(ESP8266)
	// Convertisseur sur 0..3V avec un ESP8266
	#define VOLTAGE_CONVERTER(val) float(val*3 / 1023.0)
#else
	// Convertisseur sur 0..5V avec un Atmega328 & 2560
	#define VOLTAGE_CONVERTER(val) float(val*5 / 1023.0)
#endif


#endif

//==== ANALOG WRITE AVR/ESP8266/ESP32
/*
class AnalogWriteSmart{
	public :
	static void set(uint8_t _pin, uint16_t _freq=12000, uint8_t _resolution=8){
		#if   defined(__AVR__) || defined(ESP8266)     
			pinMode(_pin, OUTPUT);
		#elif defined(ESP32)
			uint8_t channel = translateInChanel(_pin);
			ledcAttachPin(_pin, channel); // Channel = pin par choix 
			ledcSetup(channel, _freq, _resolution); // channel, 12 kHz PWM, 8-bit resolution
		#endif
	}	
	
	static void action(uint8_t _pin, uint16_t _pwm){
		uint8_t channel = translateInChanel(_pin);
		#if   defined(__AVR__) || defined(ESP8266) 
			analogWrite(_pin, _pwm);
		#elif defined(ESP32)
			ledcWrite(channel, _pwm); // Channel, valeur PWM
		#endif
	}
	
	static uint8_t translateInChanel(uint8_t _pin){
	// Permet de convertir des pins D2,D3... en n de canal. On a 15 canaux et certains n de broche sont associs  un n plus grand que 15.
		
		int8_t channel=-1;
		#if defined(ESP32)
		switch (_pin){
			case D0: channel=0;break;
			case D1: channel=1;break;
			case D2: channel=2;break;
			case D3: channel=3;break;
			case D4: channel=4;break;
			case D5: channel=5;break;
			case D6: channel=6;break;
			case D7: channel=7;break;
			case D8: channel=8;break;
			case D9: channel=9;break;
			case D10:channel=10;break;
			case D11:channel=11;break;
			case D12:channel=12;break;
			case D13:channel=13;break;
			//case D14:channel=14;break;
		}
		#endif
	return channel;
	}

};
*/


/* CHRONO : EXEMPLE#include <Duinoedu_Utility.h>

Chrono chrono1; 
Chrono chrono2; 

void setup(){
  Serial.begin(9600);
}

void loop(){

chrono1.start();
chrono2.start();

if ( chrono1.duration() > 2000) chrono1.reset();
if ( chrono2.duration() > 5000) chrono2.reset();

Serial.println("-------------");
Serial.println(chrono1.duration());
Serial.println(chrono2.duration());
}

*/




/* [EXEMPLE 01]
#include <Duinoedu_Utility.h>

String maChaine ="#LED1=ON&LED2=OFF";


void setup(){
  Serial.begin(9600);
  
}


void loop(){
  String var1 = findStringValue(maChaine,"LED1",'=','&');
  String var2 = findStringValue(maChaine,"LED2",'=','&');  

  Serial.println(var1);
  Serial.println(var2);
  delay(1000);
}

*/







